#!/usr/bin/python
import unittest
from walls import *

class MapTest(unittest.TestCase):

    def assertMap(self,expected):
        actual = str(self.tileMap).splitlines()
        expected = format_map_str(expected,"\n").splitlines()
        self.assertEqual(actual,expected, "\n".join(repr(a)+' '+repr(b) for a,b in zip(actual,expected)))

    def test1(self):
        self.tileMap = Map(9,9,"""
            .........
            ..||.....
            ..||.....
            .........
            .........
            .........
            .........
            .........
            .........
            """)
        self.tileMap.add_wall_obstacle(1,4)
        self.assertMap("""
            .........
            ..||.....
            ..||.....
            .........
            ..||.....
            ..||.....
            ..||.....
            .........
            .........
            """)

    def test2(self):
        self.tileMap = Map(9,9,"""
            .........
            ..||.....
            ..||.....
            .........
            .........
            .........
            .........
            .........
            .........
            """)
        self.tileMap.add_wall_obstacle(5,1)
        self.assertMap("""
            .........
            ..||.....
            ..||.|||.
            .....|||.
            .........
            .........
            .........
            .........
            .........
            """)

    def test3(self):
        self.tileMap = Map(11,7,"""
            ...........
            ...||......
            ...||......
            ...........
            ..||.......
            ..||.......
            ...........
            """)
        self.tileMap.add_wall_obstacle(7,2)
        self.assertMap("""
            ...........
            ...||......
            ...||......
            ......||||.
            ..||.|||||.
            ..||.||....
            ...........
            """)

    def test4(self):
        self.tileMap = Map(15,8,"""
            ...............
            .....||.||.....
            .....||.||.....
            .....||....|||.
            ...........|||.
            .||........|||.
            .||............
            .........||.||.
            """)
        self.tileMap.add_wall_obstacle(3,4)
        self.assertMap("""
            ...............
            .....||.||.....
            .....||.||.....
            .....||....|||.
            ........||.|||.
            .||.||||||.|||.
            .||.||||.......
            .........||.||.
            """)

if __name__ == "__main__":
    unittest.main()
